/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public interface IReconfigurable {
    public Direction getFacing();

    public SideConfig getSideConfig(Direction var1);

    public boolean prevSideConfig(Direction var1);

    public boolean nextSideConfig(Direction var1);

    public boolean setSideConfig(Direction var1, SideConfig var2);

    public boolean clearAllSides();

    public boolean hasInputSide();

    public boolean hasOutputSide();

    public boolean isReconfigurable();

    public static enum SideConfig implements StringRepresentable
    {
        SIDE_NONE("none", false, false),
        SIDE_INPUT("input", true, false),
        SIDE_OUTPUT("output", false, true),
        SIDE_BOTH("both", true, true),
        SIDE_ACCESSIBLE("accessible", false, false);

        public static final SideConfig[] VALUES;
        private final String name;
        private final boolean input;
        private final boolean output;

        private SideConfig(String name, boolean input, boolean output) {
            this.name = name;
            this.input = input;
            this.output = output;
        }

        public boolean isInput() {
            return this.input;
        }

        public boolean isOutput() {
            return this.output;
        }

        public SideConfig prev() {
            switch (this) {
                case SIDE_INPUT: {
                    return SIDE_NONE;
                }
                case SIDE_OUTPUT: {
                    return SIDE_INPUT;
                }
                case SIDE_BOTH: {
                    return SIDE_OUTPUT;
                }
                case SIDE_ACCESSIBLE: {
                    return SIDE_BOTH;
                }
            }
            return SIDE_ACCESSIBLE;
        }

        public SideConfig next() {
            switch (this) {
                case SIDE_NONE: {
                    return SIDE_INPUT;
                }
                case SIDE_INPUT: {
                    return SIDE_OUTPUT;
                }
                case SIDE_OUTPUT: {
                    return SIDE_BOTH;
                }
                case SIDE_BOTH: {
                    return SIDE_ACCESSIBLE;
                }
            }
            return SIDE_NONE;
        }

        public String toString() {
            return this.m_7912_();
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            VALUES = SideConfig.values();
        }
    }
}

